---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：105-Subresource Integrity

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **Turbopack統合でのSRI対応**：Turbopackビルドパイプラインでの同等機能の有無

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/webpack/plugins/subresource-integrity-plugin.ts` - SRIプラグインの実装
- E-02: `packages/next/src/server/app-render/required-scripts.tsx` - ランタイムでのintegrity属性適用
- E-03: `packages/next/src/server/config-shared.ts` - SRI設定の型定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sha256/sha384/sha512のアルゴリズムを指定可能 | E-01 (7行目) | ○ |
| C-02 | afterProcessAssetsフックで処理される | E-01 (14-17行目) | ○ |
| C-03 | PROCESS_ASSETS_STAGE_ADDITIONSステージ | E-01 (17行目) | ○ |
| C-04 | 全アセットに対してハッシュを計算 | E-01 (22-24行目) | ○ |
| C-05 | crypto.createHashでハッシュ生成 | E-01 (39-42行目) | ○ |
| C-06 | `algorithm-base64hash`形式 | E-01 (45行目) | ○ |
| C-07 | JSONとJSの2形式で出力 | E-01 (50-65行目) | ○ |
| C-08 | self.__SUBRESOURCE_INTEGRITY_MANIFESTに設定 | E-01 (53行目) | ○ |
| C-09 | SRIManifestからintegrity属性を取得 | E-02 (37-39行目) | ○ |
| C-10 | ReactDOM.preinitにintegrityを渡す | E-02 (48-55行目) | ○ |
| C-11 | preinitScriptCommandsがsrc/integrityのペア配列 | E-02 (44行目) | ○ |
| C-12 | experimental.sri設定で有効化 | E-03 (428-430行目) | ○ |
| C-13 | アセット取得失敗時にErrorをスロー | E-01 (32-33行目) | ○ |
| C-14 | TurbopackビルドでもSRIが適用される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Turbopackビルドパイプラインでの同等のSRI機能の実装有無が未確認
  - 候補：`turbopack/`ディレクトリ内の関連実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Webpackプラグインとして標準的な実装

## 6) レビュアーチェックリスト（最小）
- [ ] Turbopackビルドでの同等機能の確認
- [ ] SRIマニフェストのファイルパスとload-components.tsでの読み込みの整合性確認
